using System;

class Program
{
    static void Main()
    {
        int N = int.Parse(Console.ReadLine());

        int[] x = new int[N];
        int[] v = new int[N];

        string[] xInput = Console.ReadLine().Split();
        for (int i = 0; i < N; i++)
        {
            x[i] = int.Parse(xInput[i]);
        }

        string[] vInput = Console.ReadLine().Split();
        for (int i = 0; i < N; i++)
        {
            v[i] = int.Parse(vInput[i]);
        }

        int moment = FindOvertakingMoment(x, v);

        Console.WriteLine(moment);
    }

    static int FindOvertakingMoment(int[] x, int[] v)
    {
        int moment = -1;

        for (int i = 0; i < x.Length; i++)
        {
            for (int j = i + 1; j < x.Length; j++)
            {
                if ((x[j] - x[i]) * (v[i] - v[j]) > 0)
                {
                    int timeToOvertake = (x[j] - x[i]) / (v[i] - v[j]);
                    
                    if (moment == -1 || timeToOvertake < moment)
                    {
                        moment = timeToOvertake;
                    }
                }
            }
        }

        return moment;
    }
}